<?php
/**
 * Contact Form proccessor/validator.
 * 
 * In the Head section of your file add this line: <?php include_once("./ContactForm/ContactForm.php"); ?>
 * A good place is just above the <title>...</title> tag.
 * 
 * You can copy the contents of ContactTable.php to where ever you want the form table to appear
 * or just copy this line of code to where you want it to appear: <?php include_once("./ContactForm/ContactTable.php"); ?>
 * 
 * SECTION 1 EDIT THESE VARIABLES
 */

// Options
$form_validation  = true; // Boolean [true | false] if true, client side and server side form field validation will be done.
$auto_reply       = true; // Boolean [true | false] if true, send an auto-reply message.
$reply_from       = true; // Boolean [true | false] if true, the visitors name & email address are used in the "From:" field of the email.
$use_form_subject = true; // Boolean [true | false] if true, the visitors subject is used in the email to the admin.
$message_file     = false; // Boolean [true | false] if true, the $auto_reply text is taken from the $message_text file,
                           // otherwise it uses the text assigned to the $message_text variable. See $message_text variable that follows.
$tableHeader     = 'Email Us';  // Optional text that appears at the top of the form (table header text). Leave blank for no header.
$forward_url     = 'thankyou.htm';  // Where to send the visitor after the submit button is clicked (include path if neccessary)
                                    // If you leave it blank, your contact page will be displayed with an additional Success or Error message
                                    // Note: redirecting will only occur it the email was successfully sent.
// Required
$admin_email     = 'admin@example.com'; // The email address to send the visitors message to, and the "reply-to:" address in the auto-reply email.
$admin_name      = 'the admins name';   // The Name of the person to whom the admin email address belongs to. Must have some sort of a name/value.
$admin_prefix    = 'WebSite Enquirey';  // A pre-fix used in the email to the admin. If blank the $admin_name will be used.
$reply_prefix    = 'Acme Products';     // A pre-fix used in the auto-reply "From:" field (eg a phrase such as "Your Company name") 
                                        // If blank the $admin_name will be used.
$cc_admin        = '';  // An email address to send a CC copy to. Leave blank for no cc recipient.
$defaultSubject  = 'Contact Form Submission';      // Required in case the visitor has javascript disable and doesn't fill in the subject field.
$auto_subject    = 'Thank You for Your Comments';  // Required if $auto_reply=true.  This text will appear in the Subject line of the auto reply.

$displayMsg      = 'Your message has been successfully sent.'; // Will appear on Contact page if you are NOT using the $forward_url
$displayErr      = 'We encountered a problem and are unable to send your message.<br />Please try again later.';

// If the vistor has javascript turned off, this text will be returned if a field is blank and $form_validation=true..
// Edit the text to suite your liking.  To test this turn off javascript in your browser and submit the form with errors or balnk fields.
$formFieldsMsg   = '<tr><td colspan="2" class="CFfieldsMissing">Please fill in the fields marked with an *</td></tr>';
$fieldErrMsg     = '<span class="CFfieldsMarker"> * </span>';
// file paths
$css_style_sheet = 'ContactForm.css';  // Path to style sheet. If blank the css rules should be added to your file in the head section.
                                       // If you add the style rules to your own style sheet (that's already being loaded) leave this blank.
$javascript_path = 'ContactForm.js';   // If $form_validation=true, set path to the javascript ContactForm.js file.
                                       // If you add the javascript to your own javascript file (that's already being loaded) leave this blank.
/**
 * $message_text
 * The text used in the auto-reply can be in a file or in a variable that you edit here.
 * Using this variable is the prefered method.
 * Note: do not add "anything" on the lines that contain EOD; ( not even spaces )
 */
if(!$message_file) { 
  $message_text = <<< EOD
  
  Thank you for visiting our website. 
  We appreciate all comments and will endeavour to provide a timely response.
EOD;
}else { $message_text    = 'message.txt';}      // The text file that contains the auto response message (include path if neccessary)

/**
 * For demo purposes only. 
 * As long as the form doesn't have a input field named "redirect" this will have no affect, although you 
 * should really remove or comment out this line (add 2 forward slashes at the bebinning).
 */
if(isset($_POST['redirect']) && $_POST['redirect'] === "false") { $forward_url = "";}


/**
 * SECTION 2 DO NOT EDIT EDIT ANYTHING BEYOUND THIS POINT
 */
$fieldErr   = array("name"=>"","email"=>"","subject"=>"","message"=>"");
// set the post values in case the visitor has javascript disabled
foreach (array_keys($fieldErr) as $fieldName) { $_POST[$fieldName] = (isset($_POST[$fieldName]))? $_POST[$fieldName] : ""; }

// redirect only if the send button had been clicked
if(isset($_POST["send"])) { 
  if(trim($admin_email) === 'admin@example.com' || trim($admin_email) === '') $admin_email = $_POST["email"]; // for testing the form
  /**
   * Server Side form validation.
   */
  $valid = true;
  if($form_validation) { 
    foreach (array_keys($fieldErr) as $fieldName) {
    	if(trim($_POST[$fieldName]) === "") { 
    	  $fieldErr[$fieldName] = $fieldErrMsg;
    	  $valid = false;
    	}
    }
  }
  if($valid) {
    /**
     * FORM HACK/SPAM FILTER
     * If any of the values in the spam filter appear in the request the visitor will receive the "Banned" message.
     */
    $spam_filter = array('Content-Type','MIME-Version','[url=','&#','href=','mail.de');
    foreach ($_REQUEST as $j => $request_value) {
      foreach ($spam_filter as $k =>$spam_value) {
        if (stristr($request_value,$spam_value)) {
          header("HTTP/1.0 403 Forbidden");
          echo "YOU HAVE BEEN BANNED FROM ACCESSING THIS SERVER FOR TRIGGERING OUR SPAMMER TRAP";
          exit;
        }
      }
    }
    
    // concantinate the form data to put in the admin's email
    $form_results = '';
    foreach ($_POST as $j =>$value) { if($j !== "send") { $form_results .= $j.': ' .$value."\n";};} // excluding the send button value.
    
    // Build the email header
    $headers  = "MIME-Version: 1.0\n";
    $headers .= "Content-type: text/plain; charset=iso-8859-1\n";
    $headers .= "X-Priority: 3\n";
    $headers .= "X-MSMail-Priority: Normal\n";
    
    // Reply From 
    if($reply_from) {
      if(isset($_POST["email"]) && isset($_POST["name"])) {
        $reply_from = "From: \"".$_POST["name"]."\" <".$_POST["email"].">\n";
      }else if(isset($_POST["email"])) {
        $reply_from = "From: ".$_POST["email"]."\n";
      }else { $reply_from = false; }  // could end up as false if form validation was not used
    }
    if(!$reply_from) { $reply_from = "From: \"".$admin_name."\" <".$admin_email.">\n";}
    
    // To admin
    $admin = ($admin_prefix === '')? $admin_email : $admin_prefix." <".$admin_email.">";
    
    // Subject
    if($use_form_subject && isset($_POST["subject"]) && trim($_POST["subject"]) !== "") {
      $subject = trim($_POST["subject"]);
    }else { $subject = $defaultSubject;}
    
    // CC 
    $cc_admin = ($cc_admin !== '')? "Cc: ".$cc_admin."\n" : "";
    
    // email to admin
    $success = mail($admin,$subject,$form_results,$headers.$cc_admin.$reply_from);  // SEND MESSAGE TO YOU WITH FORM RESULTS
    if(!$success){ $displayMsg=$displayErr;}
    
    // The auto response message (if $auto_reply=true)
    if($auto_reply) {
      $message = ($message_file)? file_get_contents($message_text) : $message_text;
      // set the recipient
      if(isset($_POST["email"]) && isset($_POST["name"])) {  // may not be set if form validation wasn't used.
        $recipient = $_POST["name"]." <".$_POST["email"].">";
      }else if(isset($_POST["email"])) {
        $recipient = $_POST["email"];
      }else { $auto_reply = false; }  // could end up as false if form validation was not used
      // send if $auto_reply is still true
      if($auto_reply) { 
        $reply_prefix = ($reply_prefix === '')? $admin_name : $reply_prefix;
        $reply_from = "From: \"".$reply_prefix."\" <".$admin_email.">\n";
        mail($recipient,$auto_subject,$message,$headers.$reply_from);
      }
    }
    // reset the POST variables
    if ($success) foreach (array_keys($_POST) as $key) {$_POST[$key] = "";}
    // show page
    if($forward_url !== '' && $success) header("location: ".$forward_url); // forward to the thank you page if set.
  }
}
/**
 * This javascript and style sheet will be inserted into the Head section of the file.
 */
if($form_validation) echo '<script type="text/javascript" src="'.$javascript_path.'"></script>';
if($css_style_sheet !== '') echo '<link rel="stylesheet" type="text/css" href="'.$css_style_sheet.'" />';

?>